'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"flutter_bootstrap.js": "699bf0032eeb1966e11e0811a5015e8f",
"canvaskit/skwasm.worker.js": "bfb704a6c714a75da9ef320991e88b03",
"canvaskit/skwasm.js.symbols": "c3c05bd50bdf59da8626bbe446ce65a3",
"canvaskit/canvaskit.wasm": "9251bb81ae8464c4df3b072f84aa969b",
"canvaskit/chromium/canvaskit.wasm": "399e2344480862e2dfa26f12fa5891d7",
"canvaskit/chromium/canvaskit.js.symbols": "ee7e331f7f5bbf5ec937737542112372",
"canvaskit/chromium/canvaskit.js": "901bb9e28fac643b7da75ecfd3339f3f",
"canvaskit/canvaskit.js.symbols": "74a84c23f5ada42fe063514c587968c6",
"canvaskit/skwasm.js": "5d4f9263ec93efeb022bb14a3881d240",
"canvaskit/skwasm.wasm": "4051bfc27ba29bf420d17aa0c3a98bce",
"canvaskit/canvaskit.js": "738255d00768497e86aa4ca510cce1e1",
"assets/assets/pdfs/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/assets/images/boleto-icon.svg": "785580fba74d1adbc13e8240fa5b5886",
"assets/assets/images/search-icon.svg": "cc5ac69fb8092811be480de3728f5035",
"assets/assets/images/contacts-icon.png": "4c0c7e86bde9088a6d82792299ba81e5",
"assets/assets/images/favorites-icon.png": "a986c6a88650a950edfcdcfb115ba5da",
"assets/assets/images/banco-do-brasil-logo.png": "29e91d9bdc4eff681f5a34098ed4bcc9",
"assets/assets/images/brazil-icon.png": "ad06710e7b0572b9fdf84ad4aa460a32",
"assets/assets/images/navbar-border.svg": "d78f2bbc391aa6e2a5e2a520b8a48aa9",
"assets/assets/images/home-icon.svg": "eabfd6e561e20d64c7ca2aeb47140dd1",
"assets/assets/images/usa-icon.png": "689e1c691ed189461c187cdf97c7d1c0",
"assets/assets/images/maps-icon.png": "115a80061bf85d91acb48860caae0293",
"assets/assets/images/qrcode-icon.svg": "b3beabf9366b68f703768f0597aff06f",
"assets/assets/images/heart-blue-icon.svg": "927c806082841150f54b4555f04273e1",
"assets/assets/images/idiom-icon.png": "47e74e2b32319aecbc60afd4fa4c70a3",
"assets/assets/images/app_launcher_icon.png": "23c0d8b52cb97a67abf68c8a62d7e9bd",
"assets/assets/images/card-icon.svg": "ceb3496b9491c5ab6b3473bf0f3a64fd",
"assets/assets/images/paper-blue-icon.svg": "bdeb16ed98ae00ea3d868574ed8e65d5",
"assets/assets/images/maps-blue-icon.svg": "5bccddb5158e4fa6528fbf6b1972416f",
"assets/assets/images/paper-icon.svg": "94561f12e4016c6f9350a0d7e181346c",
"assets/assets/images/logout-icon.png": "4d8b454b33c7037e83889bd44ba56445",
"assets/assets/images/menu-icon.png": "08c5e07bc2b24c6dbfe4239bb54110f4",
"assets/assets/images/speaker-icon.png": "8deab434a6775e63d382ec3e5137457e",
"assets/assets/images/user-icon.svg": "9f19b6504fd7dc7f969bc2162a2dbfdb",
"assets/assets/images/boleto.svg": "63689627e6024be74a39fa8eeaa547f6",
"assets/assets/images/news-icon.png": "883531575b3c359c1c2eb3078ca2a386",
"assets/assets/images/adaptive_foreground_icon.png": "23c0d8b52cb97a67abf68c8a62d7e9bd",
"assets/assets/images/error_image.png": "23c0d8b52cb97a67abf68c8a62d7e9bd",
"assets/assets/images/credit-card.svg": "155bd48dc73e89c56c4f8ad2f42372e3",
"assets/assets/images/orders-icon.png": "8f9ecd08da98390ae89c910eba67738f",
"assets/assets/images/pix-icon.svg": "bedfa94e32b3c873f511ec5811f047c8",
"assets/assets/images/ecolife-logo.png": "dee3e643efa7f1d2cc7c05d3b7f59f30",
"assets/assets/images/bndes-logo.png": "8f44111bc43118fe83ee72df0f37407e",
"assets/assets/images/box-icon.svg": "78c7b72c9f6f55d09a1b440a33eb69e6",
"assets/assets/images/coin-icon.svg": "17663b43b90210f8dc45d70988b3ab91",
"assets/assets/images/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/assets/fonts/Poppins-Regular.ttf": "093ee89be9ede30383f39a899c485a82",
"assets/assets/fonts/Poppins-Medium.ttf": "bf59c687bc6d3a70204d3944082c5cc0",
"assets/assets/fonts/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/assets/videos/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/assets/audios/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/assets/rive_animations/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/assets/lottie_animations/favicon.png": "5dcef449791fa27946b3d35ad8803796",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"assets/NOTICES": "6283650545be0c8dbd09a3df1d3193d1",
"assets/fonts/MaterialIcons-Regular.otf": "47d750dc21e64f44f6a51d6909e00ea1",
"assets/AssetManifest.bin": "191914243a6b9f64c6078708817885a9",
"assets/AssetManifest.json": "e6299de010066b1ca06ebe0e2915722d",
"assets/AssetManifest.bin.json": "2fcacf81a5881bc8187dc74db01be258",
"assets/FontManifest.json": "5a32d4310a6f5d9a6b651e75ba0d7372",
"assets/packages/font_awesome_flutter/lib/fonts/fa-solid-900.ttf": "ad72c31fd66903172ff66ca59ab9f0bd",
"assets/packages/font_awesome_flutter/lib/fonts/fa-regular-400.ttf": "60170625fd25bb7175a67ccd0aa23e7e",
"assets/packages/font_awesome_flutter/lib/fonts/fa-brands-400.ttf": "d0ac55f4f803e05d41c3871baef49a6a",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "e986ebe42ef785b27164c36a9abc7818",
"assets/packages/flutter_google_places/assets/google_white.png": "40bc3ae5444eae0b9228d83bfd865158",
"assets/packages/flutter_google_places/assets/google_black.png": "97f2acfb6e993a0c4134d9d04dff21e2",
"assets/packages/google_places_flutter/images/location.json": "afa33acf2c340246c901718f4efdfccf",
"main.dart.js": "34ee0b2f9ae2fb7e82cce88776571c32",
"version.json": "9ee3c5db080c11dfc8c9b76ac86ab3b5",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/app_launcher_icon.png": "23c0d8b52cb97a67abf68c8a62d7e9bd",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"index.html": "623c6a3d545ea0787c62570085f8c1b6",
"/": "623c6a3d545ea0787c62570085f8c1b6",
"flutter.js": "383e55f7f3cce5be08fcf1f3881f585c",
"favicon.png": "2704101cb06ce66e2000356a312be25c"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
